<?php

class DBManager {

    /*
    * PDO sınıf örneğinin barınacağı değişken
    */
    private static $instance = null;

    /*
    * Kullanacağımız veritabanı karakter seti
    */
    private static $charset = 'UTF8';

    /*
    * PDO örneğini döndüren metod
    */
    private $pdo;

    /*
    * PDO bağlantısını kuran metot
    */
    private function __construct()
    {
        try {
            $this->pdo = new PDO(
                'mysql:host=' . MYSQL_HOST . ';dbname=' . MYSQL_DB,
                MYSQL_USER,
                MYSQL_PASS
            );

            $this->pdo->exec('SET NAMES `' . self::$charset . '`');
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            die("Veritabanı bağlantı hatası: " . $e->getMessage());
        }
    }

    /*
    * Singleton PDO örneğini döndüren metod
    */
    public static function getInstance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /*
    * PDO örneğini dışarıdan erişilebilir hale getirir
    */
    public function getConnection()
    {
        return $this->pdo;
    }

    /*
    * PDO'nun query metodu
    */
    public function query($query, $bindings = null)
    {
        $stmt = $this->pdo->prepare($query);
        if ($bindings) {
            $stmt->execute($bindings);
        } else {
            $stmt->execute();
        }
        return $stmt;
    }

    /*
    * Yapılan sorgunun ilk satırının ilk değerini döndüren metod
    */
    public function getVar($query, $bindings = null)
    {
        $stmt = $this->query($query, $bindings);
        return $stmt->fetchColumn();
    }

    /*
    * Yapılan sorgunun ilk satırını döndüren metod
    */
    public function getRow($query, $bindings = null)
    {
        $stmt = $this->query($query, $bindings);
        return $stmt->fetch();
    }

    /*
    * Yapılan sorgunun tüm satırlarını döndüren metod
    */
    public function get($query, $bindings = null)
    {
        $stmt = $this->query($query, $bindings);
        return $stmt->fetchAll();
    }

    /*
    * Etkilenen satır sayısını döndürür
    */
    public function exec($query, $bindings = null)
    {
        $stmt = $this->query($query, $bindings);
        return $stmt->rowCount();
    }

    /*
    * Son eklenen ID'yi döndürür
    */
    public function insert($query, $bindings = null)
    {
        $stmt = $this->query($query, $bindings);
        return $this->pdo->lastInsertId();
    }

    /*
    * Son gerçekleşen sorgudaki (varsa) hatayı döndüren metod
    */
    public function getLastError()
    {
        return $this->pdo->errorInfo();
    }

    /*
    * PDO metodlarını doğrudan çağırmak için sihirli metot
    */
    public function __call($name, $arguments)
    {
        return call_user_func_array([$this->pdo, $name], $arguments);
    }
}
